function kilroyWasHere() {
    /* widget controller */
    var c = this;
    var taskTypes = ['sn_customerservice_case', 'incident', 'task', 'problem'];
    var contactTypes = ['customer_contact', 'sys_user'];
    var searchScreenPopPrefix = 'search:';

    var activeItemId = null;
    /*
        type itemsData = {
            [itemId: string]: {
                oldHref: string
                encounteredObjects: Array<{ id: string, entity: string }>
                important: { entity: string, id: string } | null
            }
        }
    */
    var itemsData = {};
    var pendingImportant = null; // { entity: string, id: string } | null
    var nextScreenPopItemId = null;

    function parseQueryString(query) {
        var vars = query.split('&');
        var queryString = {};
        for (var i = 0; i < vars.length; i++) {
          var pair = vars[i].split('=');
            var key = decodeURIComponent(pair[0]);
            var value = decodeURIComponent(pair[1]);
            if (typeof queryString[key] === 'undefined') {
                queryString[key] = decodeURIComponent(value);
            } else if (typeof queryString[key] === 'string') {
                var arr = [queryString[key], decodeURIComponent(value)];
                queryString[key] = arr;
            } else {
                queryString[key].push(decodeURIComponent(value));
            }
        }
        return queryString;
    }

    function findLast(array, predicate) {
        for (var i = array.length - 1; i >= 0; i--) {
            if (predicate(array[i])) {
                return array[i];
            }
        }
        return null;
    }

    function findIndex(array, predicate) {
        for (var i = 0; i < array.length; i++) {
            if (predicate(array[i])) {
                return i;;
            }
        }
        return -1;
    }

    var initialTitle = window.top.document.title;
    var defaultBlinkingTitleValue = 'New screen';
    var blinkingTitleValue = defaultBlinkingTitleValue;
    var titleBlinkingIntervalId = -1;

    function startTitleBlinking() {
        initialTitle = window.top.document.title;
        titleBlinkingIntervalId = setInterval(function () {
            window.top.document.title = window.top.document.title === blinkingTitleValue ? initialTitle : blinkingTitleValue;
        }, 700);
    }
    function stopTitleBlinking() {
        if (titleBlinkingIntervalId === -1) {
            return;
        } 
        clearInterval(titleBlinkingIntervalId);
        titleBlinkingIntervalId = -1;
        window.top.document.title = initialTitle;
    }

    var bpatternOrigin = parseQueryString(window.location.search.substring(1))['bpatternOrigin'];
    if (!bpatternOrigin) {
        throw Error('OpenFrame: "bpattern_origin" parameter in URL is required!');
    }
    var serviceNowOrigin = window.origin;

    var REPEATER_TO_PROXY = {
        PING: 'sn_proxy_ping',
        INIT: 'sn_proxy_init',
        SHOW_WIDGET: 'sn_proxy_show_widget',
        SAVE_ACTIVITY: 'sn_proxy_save_activity',
        OPEN_FORM: 'sn_proxy_open_form',
        SEARCH: 'sn_proxy_search',
        REPEATER_MESSAGE: 'sn_proxy_repeater_message',
    };
    var PROXY_TO_REPEATER = {
        PONG: 'sn_proxy_pong',
        CRM_ORIGIN: 'sn_crm_origin',
        SCREEN: 'sn_proxy_screen',
        CLICK_TO_CALL: 'sn_proxy_click_to_call',
        ACTIVATION_TIMESTAMP: 'sn_proxy_activation_timestamp'
    };
    var PROXY_TO_SERVICENOW = {
        SAVE_ACTIVITY: 'saveactivityhistory'
    };

    var completedBPatternOrigin = (bpatternOrigin.length > 8 && bpatternOrigin.slice(0, 8) === 'https://' ? '' : 'https://') + bpatternOrigin;

    var bpatternIframe = null;
    function createAgentDesktopIframe() {
        bpatternIframe = document.createElement('iframe');
        bpatternIframe.id = 'bpattern_ad';
        bpatternIframe.allow = 'microphone; camera; geolocation';
        bpatternIframe.src =  completedBPatternOrigin + '/agentdesktop/ServiceNow.jsp?topDomain=' + serviceNowOrigin;

        var frameContainer = document.getElementById('bpattern_iframe_container');
        frameContainer.appendChild(bpatternIframe);
    }

    function consoleLog() {
        console.log(
            '@@@BP SN Adapter: ',
            JSON.stringify(arguments[0]) || '',
            JSON.stringify(arguments[1]) || '',
            JSON.stringify(arguments[2]) || '',
            JSON.stringify(arguments[3]) || ''
        );
    }
    function consoleWarn() {
        console.warn(
            '@@@BP SN Adapter: ',
            JSON.stringify(arguments[0]) || '',
            JSON.stringify(arguments[1]) || '',
            JSON.stringify(arguments[2]) || '',
            JSON.stringify(arguments[3]) || ''
        );
    }
    function consoleError() {
        console.error(
            '@@@BP SN Adapter: ',
            JSON.stringify(arguments[0]) || '',
            JSON.stringify(arguments[1]) || '',
            JSON.stringify(arguments[2]) || '',
            JSON.stringify(arguments[3]) || ''
        );
    }

    function doSearchScreenPop(itemId, entity, query) {
        window.openFrameAPI.openServiceNowList({
            entity: entity,
            query: query
        });
        setTimeout(function () {
            if (itemsData[itemId]) {
                consoleLog('Clear saved objects after search screen pop for interaction ' + itemId + ': ', itemsData[itemId].encounteredObjects);
                itemsData[itemId].encounteredObjects = [];
            }
        }, 1000);
    }

    function addNewInteraction(itemId) {
        itemsData[itemId] = {
            oldHref: '',
            encounteredObjects: [],
            important: null
        };
        consoleLog('New interaction ', itemId);
        if (pendingImportant) {
            consoleLog('with pending ', pendingImportant.entity, ' = ', pendingImportant.id);
            itemsData[itemId].important = pendingImportant;
            consoleLog('Add associated object to interaction: ', itemId, pendingImportant);
            itemsData[itemId].encounteredObjects.push(pendingImportant);
            bpatternIframe.contentWindow.postMessage({
                type: PROXY_TO_REPEATER.SCREEN,
                data: pendingImportant
            }, '*');
            pendingImportant = null;
        }
    }

    function initializeAgentDesktop() {

        createAgentDesktopIframe();

        setInterval(function () {
            if (!activeItemId || !itemsData[activeItemId]) {
                return;
            }
            if (window.top.location.href === itemsData[activeItemId].oldHref) {
                return;
            }
            consoleLog('New URL detected:', window.top.location.href);
            itemsData[activeItemId].oldHref = window.top.location.href;
            var uriData = parseQueryString(window.top.location.search.substring(1))['uri'];
            if (uriData) {
                var splits = uriData.split('?');
                var args = parseQueryString(splits.length > 1 ? splits.slice(1).join('?') : '');
                var sysId = args['sys_id']; // i.e. '3af07e332f065010058caf5df699b680'
                var sysparmRecordTarget = args['sysparm_record_target']; // i.e. 'sn_customerservice_case'
                var objectPath = (splits[0].indexOf('/') === 0 && splits[0].indexOf('.do') === splits[0].length - '.do'.length)
                    ? splits[0].substring(1, splits[0].length - '.do'.length)
                    : undefined
                var entityType = null;
                if (sysId && !itemsData[activeItemId].important) {
                    if (taskTypes.indexOf(sysparmRecordTarget) !== -1 || contactTypes.indexOf(sysparmRecordTarget) !== -1) {
                        entityType = sysparmRecordTarget;
                    }
                    if (taskTypes.indexOf(objectPath) !== -1 || contactTypes.indexOf(objectPath) !== -1) {
                        entityType = objectPath;
                    }
                    if (entityType) {
                        var screenObject = {
                            entity: entityType,
                            id: sysId
                        };
                        consoleLog('Add associated object to interaction: ', activeItemId, screenObject);
                        itemsData[activeItemId].encounteredObjects.push(screenObject);
                        bpatternIframe.contentWindow.postMessage({
                            type: PROXY_TO_REPEATER.SCREEN,
                            data: screenObject
                        }, '*');
                    }
                }
            }
        }, 300);

        function saveActivityHistoryRecord(activity) {
            if (!activity.globalInteractionId || !activity.type || activity.type === 'unknown') {
                consoleWarn('Skip save activity for bad interaction: ', activity);
                return;
            }
            var itemId = activity.itemId;
            var screenPopEntityId = activity['sn:task'] || activity['sn:contact'];
            if (screenPopEntityId) {
                var screenPopEntityIndex = findIndex(itemsData[itemId].encounteredObjects, function (obj) {
                    return obj.id === screenPopEntityId;
                });
                if (screenPopEntityIndex !== -1) {
                    consoleLog('Slice encountered object before ScreenPop object: ', itemsData[itemId].encounteredObjects[0]);
                    itemsData[itemId].encounteredObjects = itemsData[itemId].encounteredObjects.slice(screenPopEntityIndex);
                }
            }
            consoleLog('Associated objects for interaction ' + itemId + ': ', itemsData[itemId].encounteredObjects);
            var task = findLast(itemsData[itemId].encounteredObjects, function (obj) {
                return taskTypes.indexOf(obj.entity) !== -1;
            });
            var contact = findLast(itemsData[itemId].encounteredObjects, function (obj) {
                return contactTypes.indexOf(obj.entity) !== -1;
            });
            var serverRequest = {
                action: PROXY_TO_SERVICENOW.SAVE_ACTIVITY,
                data: activity,
                taskId: (itemsData[itemId].important && taskTypes.indexOf(itemsData[itemId].important.entity) !== -1)
                    ? itemsData[itemId].important.id
                    : task ? task.id : undefined,
                contactId: (itemsData[itemId].important && contactTypes.indexOf(itemsData[itemId].important.entity) !== -1)
                    ? itemsData[itemId].important.id
                    : contact ? contact.id : undefined
            };
            consoleLog('SaveActivityHistory Server Request: ', serverRequest);
            c.server.get(serverRequest).then(function (result) {
                consoleLog('SaveActivityHistory Request Result: ', result.data);
            });
            delete itemsData[itemId];
        }

        window.addEventListener('message', function (e) {
            if (e.data && e.origin === completedBPatternOrigin) {
                switch (e.data.type) {

                    case REPEATER_TO_PROXY.SAVE_ACTIVITY:
                        saveActivityHistoryRecord(e.data.data.activity);
                        break;

                    case REPEATER_TO_PROXY.INIT:
                        window.openFrameAPI.init(
                            e.data.data.config || {},
                            function onSuccess(snConfig) {
                                consoleLog('OpenFrame init success, with config: ', snConfig);
                                window.openFrameAPI.subscribe(
                                    window.openFrameAPI.EVENTS.COMMUNICATION_EVENT,
                                    function (context) {
                                        if (context.type === 'OUTGOING_CALL') {
                                            var task = context.data.data.find(function (obj) {
                                                return taskTypes.indexOf(obj.entity) !== -1;
                                            });
                                            var contact = context.data.data.find(function (obj) {
                                                return contactTypes.indexOf(obj.entity) !== -1;
                                            });
                                            if (task) {
                                                var match = task.query.match(/sys_id=([0-9a-f]+)(?:&|$)/);
                                                if (match) {
                                                    pendingImportant = {
                                                        entity: task.entity,
                                                        id: match[1]
                                                    };
                                                    setTimeout(function() {
                                                        pendingImportant = null;
                                                    }, 30000);
                                                }
                                            } else if (contact) {
                                                var match = contact.query.match(/sys_id=([0-9a-f]+)(?:&|$)/);
                                                if (match) {
                                                    pendingImportant = {
                                                        entity: contact.entity,
                                                        id: match[1]
                                                    };
                                                    setTimeout(function() {
                                                        pendingImportant = null;
                                                    }, 30000);
                                                }
                                            }
                                            window.openFrameAPI.show();
                                            consoleLog('Context: ', context);
                                            bpatternIframe.contentWindow.postMessage({
                                                type: PROXY_TO_REPEATER.CLICK_TO_CALL,
                                                data: {
                                                    phone: context.data.metaData.phoneNumber
                                                }
                                            }, '*');
                                        }
                                    }
                                );
                                var crmOrigin = window.top.location.origin;
                                consoleLog('Send CRM Origin: ', crmOrigin);
                                bpatternIframe.contentWindow.postMessage({
                                    type: PROXY_TO_REPEATER.CRM_ORIGIN,
                                    data: {
                                        crmOrigin: crmOrigin
                                    }
                                }, '*');
                            },
                            function onFail(e) {
                                consoleError('OpenFrame init failed...', e);
                            }
                        );
                        break;

                    case REPEATER_TO_PROXY.SHOW_WIDGET:
                        window.openFrameAPI.show();
                        break;

                    case REPEATER_TO_PROXY.OPEN_FORM:
                        consoleLog('Screen pop handler for item ' + nextScreenPopItemId + ': ', e.data.data.form);
                        if (nextScreenPopItemId) {
                            if (!e.data.data.form.newTab) {
                                if (e.data.data.form.query.indexOf(searchScreenPopPrefix) === 0) {
                                    var searchQuery1 = e.data.data.form.query.substring(searchScreenPopPrefix.length);
                                    doSearchScreenPop(nextScreenPopItemId, e.data.data.form.entity, searchQuery1);
                                } else if (e.data.data.form.query.indexOf('sys_id=' + searchScreenPopPrefix) === 0) {
                                    var searchQuery2 = e.data.data.form.query.substring(('sys_id=' + searchScreenPopPrefix).length);
                                    doSearchScreenPop(nextScreenPopItemId, e.data.data.form.entity, searchQuery2);
                                } else {
                                    window.openFrameAPI.openServiceNowForm({
                                        entity: e.data.data.form.entity,
                                        query: e.data.data.form.query
                                    });
                                }
                                if (window.top.document.visibilityState !== 'visible') {
                                    startTitleBlinking();
                                }
                            }
                            if (itemsData[nextScreenPopItemId] && itemsData[nextScreenPopItemId].encounteredObjects.length) {
                                consoleLog('Clear associated objects grabbed before screen pop for interaction ' + nextScreenPopItemId + ':', itemsData[nextScreenPopItemId].encounteredObjects);
                                itemsData[nextScreenPopItemId].encounteredObjects = [];
                            }
                        }
                        break;

                    case REPEATER_TO_PROXY.SEARCH:
                        consoleLog('Screen pop search handler for item ' + nextScreenPopItemId + ': ', e.data.data);
                        if (nextScreenPopItemId) {
                            if (!e.data.data.newTab) {
                                doSearchScreenPop(nextScreenPopItemId, e.data.data.entity, e.data.data.query);
                                if (window.top.document.visibilityState !== 'visible') {
                                    startTitleBlinking();
                                }
                            }
                            if (itemsData[nextScreenPopItemId] && itemsData[nextScreenPopItemId].encounteredObjects.length) {
                                consoleLog('Clear associated objects grabbed before screen pop for interaction ' + nextScreenPopItemId + ':', itemsData[nextScreenPopItemId].encounteredObjects);
                                itemsData[nextScreenPopItemId].encounteredObjects = [];
                            }
                        }

                    case REPEATER_TO_PROXY.PING:
                        consoleLog('RECEIVED PING');
                        bpatternIframe.contentWindow.postMessage({
                            type: PROXY_TO_REPEATER.PONG,
                            data: {}
                        }, '*');
                        break;

                    case REPEATER_TO_PROXY.REPEATER_MESSAGE: {
                        try {
                            var msg = e.data.data.message;
                            switch (msg.command) {
                                case 'INTERACTION_RENDERED':
                                    if (msg.data.item_id && !itemsData[msg.data.item_id]) {
                                        addNewInteraction(msg.data.item_id);
                                    }
                                    break;
                                case 'INTERACTION_SELECTED':
                                    if (activeItemId !== msg.data) {
                                        consoleLog('Active item id changed:', msg.data);
                                    }
                                    activeItemId = msg.data || null;
                                    if (activeItemId && !itemsData[activeItemId]) {
                                        addNewInteraction(activeItemId);
                                    }
                                    break;
                                case 'CONVERSATION_LIST':
                                    if (msg.data.selected) {
                                        activeItemId = msg.data.selected.id;
                                        if (!itemsData[activeItemId]) {
                                            addNewInteraction(activeItemId);
                                        }
                                    }
                                    break
                                case 'INTERACTION_COMPLETED':
                                    if (activeItemId === msg.data.item_id) {
                                        activeItemId = null;
                                    }
                                    delete itemsData[msg.data.item_id];
                                    consoleLog('Interaction removed ', msg.data.item_id);
                                    break;
                                case 'SHOW_SCREEN_POP':
                                    if (msg.data.type === 'servicenow' && !msg.data.newTab) {
                                        nextScreenPopItemId = msg.data.item_id;
                                    }
                                    break;
                            }
                        } catch (e) {
                            consoleWarn('Cannot parse repeater message: ', e.data.data.message);
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
        });

        window.top.addEventListener('visibilitychange', function () {
            if (window.top.document.visibilityState === 'visible') {
                stopTitleBlinking();
                consoleLog('generate WINDOW_FOCUS_EVENT on visibility change');
                latestFocusTimestamp = Date.now();
                bpatternIframe.contentWindow.postMessage({
                    type: PROXY_TO_REPEATER.ACTIVATION_TIMESTAMP,
                    data: {timestamp: latestFocusTimestamp}
                }, '*');
            }
        });

        window.top.addEventListener('focus', function () {
            consoleLog('generate WINDOW_FOCUS_EVENT on focus');
            latestFocusTimestamp = Date.now();
            bpatternIframe.contentWindow.postMessage({
                type: PROXY_TO_REPEATER.ACTIVATION_TIMESTAMP,
                data: {timestamp: latestFocusTimestamp}
            }, '*');
        });
    }

    if (document.readyState === 'complete') {
        initializeAgentDesktop();
    } else {
        window.addEventListener('load', initializeAgentDesktop);
    }
}
